/// Enigma API implementation
using System;
using System.Runtime.InteropServices;

/// <summary>
/// Summary description for Enigma_IDE
/// </summary>
/// 

public class Enigma_KeyGen_IDE
{
	public const uint ERROR_UNKNOWN                       = 0xFFFFFFFF;
	public const uint ERROR_OK                            = 0x00000000;
	public const uint ERROR_KEY_BUFFER_NOT_ALLOCATED      = 0x00000001;
	public const uint ERROR_KEY_BUFFER_LESS               = 0x00000002;
	public const uint ERROR_REGINFO_BUFFER_NOT_ALLOCATED  = 0x00000003;
	public const uint ERROR_REGINFO_BUFFER_EMPTY          = 0x00000004;
	public const uint ERROR_HARDWARE_TYPE_UNKNOWN         = 0x00000005;
	public const uint ERROR_HARDWARE_ID                   = 0x00000006;
	public const uint ERROR_HARDWARE_BUFFER_NOT_ALLOCATED = 0x00000007;
	public const uint ERROR_HARDWARE_BUFFER_EMPTY         = 0x00000008;
	public const uint ERROR_INVALID_CONSTANT_D            = 0x00000009;
	public const uint ERROR_INVALID_CONSTANT_N            = 0x0000000A;
	public const uint ERROR_INVALID_CONSTANT_A            = 0x0000000B;
	public const uint ERROR_INVALID_CONSTANT_B            = 0x0000000C;
	public const uint ERROR_PROJECT_FILE_NOT_FOUND        = 0x0000000D;
	public const uint ERROR_PROJECT_FILE_INVALID          = 0x0000000E;

	public const int NUMBER_OF_CRYPTED_SECTIONS          = 16;

    // Key type constants
    public const byte KEY_TYPE_LONG = 0;
    public const byte KEY_TYPE_SHORT = 1;

    // Key formatting constants
    public const byte KEY_FORMAT_10 = 10;
    public const byte KEY_FORMAT_16 = 16;
    public const byte KEY_FORMAT_32 = 32;
    public const byte KEY_FORMAT_64 = 64;

	public struct GenKeyParams
	{
        public Byte KeyType;
        public Byte KeyFormat;
        public Int16 Reserved3;
		public string Key;
		public Int32 KeyLen;
		public string RegInfo;
		public Int32 RegInfoLen;
		public Byte UseKeyExpiration;
		public Byte Reserved1;
		public Int16 ExpirationYear;
		public Byte ExpirationMonth;
		public Byte ExpirationDay;
		public Byte UseHardwareLocking;
		public Byte Reserved2;
		public string HardwareID;
        public byte Section1;
        public byte Section2;
        public byte Section3;
        public byte Section4;
        public byte Section5;
        public byte Section6;
        public byte Section7;
        public byte Section8;
        public byte Section9;
        public byte Section10;
        public byte Section11;
        public byte Section12;
        public byte Section13;
        public byte Section14;
        public byte Section15;
        public byte Section16;
		public string D;
		public string N;
		public string A;
		public string B;
	}

	// Enigma keygen API
	[DllImport("keygen.dll", CallingConvention = CallingConvention.StdCall)]
	public static extern uint KG_GenerateRegistrationKey(ref GenKeyParams KeyParams);
	[DllImport("keygen.dll", CallingConvention = CallingConvention.StdCall)]
	public static extern uint KG_GenerateRegistrationKeyFromProject(string FileName, ref GenKeyParams KeyParams);
}
